<?php
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'debit_note_add') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';die();
  }

  $vendor = mysqli_query($conn, "SELECT * FROM `vendor_master` WHERE `status` = '0' ORDER BY name ASC");
  $vdata = array();
  while ($rows = mysqli_fetch_assoc($vendor)) {
    $vdata[] = $rows;
  }

  $tax = mysqli_query($conn, "SELECT * FROM `tax_mst` WHERE `sign` = '+' AND FIND_IN_SET('BILL', module)");
  $tax_rows = array();
  while($tax_row = mysqli_fetch_assoc($tax)) {
    $tax_rows[] = $tax_row;
  }

  $d_tax = mysqli_query($conn, "SELECT * FROM `tax_mst` WHERE `sign` = '-' AND FIND_IN_SET('BILL', module)");
  $d_tax_rows = array();
  while($d_tax_row = mysqli_fetch_assoc($d_tax)) {
    $d_tax_rows[] = $d_tax_row;
  }

  if (isset($_REQUEST['p1']) && !empty($_REQUEST['p1']) && $_REQUEST['p1']!=0){
    $credit = mysqli_query($conn, "SELECT * FROM `debit_note` WHERE `id` = '".$_REQUEST['p1']."'");
    $credit_row = mysqli_fetch_assoc($credit);
    $id             = $credit_row['id'];
    $code           = $credit_row['code'];
    $date           = $credit_row['date'];
    $supplier_id    = $credit_row['supplier_id'];
    $gross_amount   = $credit_row['gross_amount'];
    $addition       = $credit_row['addition'];
    $deduction      = $credit_row['deduction'];
    $cgst_per       = $credit_row['cgst_per'];
    $cgst_amount    = $credit_row['cgst_amount'];
    $sgst_per       = $credit_row['sgst_per'];
    $sgst_amount    = $credit_row['sgst_amount'];
    $igst_per       = $credit_row['igst_per'];
    $igst_amount    = $credit_row['igst_amount'];
    $taxable_amount = $credit_row['taxable_amount'];
    $net_amount     = $credit_row['net_amount'];

    $query = mysqli_query($conn, "SELECT * FROM `debit_note_details` WHERE `master_id` = '".$_REQUEST['p1']."'");
    $detail = array();
    while ($rows = mysqli_fetch_assoc($query)) {
      $detail[] = $rows;
    }

    $addtax_history = mysqli_query($conn, "SELECT * FROM `debit_note_tax_details` WHERE `master_id` = '".$_REQUEST['p1']."' AND `type` = 'add'");
    $add_tax = array();
    while ($addtax_history_row = mysqli_fetch_assoc($addtax_history)) {
      $add_tax[$addtax_history_row['key']] = array('id' => $addtax_history_row['tax_mst_id'], 'amount' => $addtax_history_row['amount']);
    }

    $lesstax_history = mysqli_query($conn, "SELECT * FROM `debit_note_tax_details` WHERE `master_id` = '".$_REQUEST['p1']."' AND `type` = 'less'");
    $less_tax = array();
    while ($lesstax_history_row = mysqli_fetch_assoc($lesstax_history)) {
      $less_tax[$lesstax_history_row['key']] = array('id' => $lesstax_history_row['tax_mst_id'], 'amount' => $lesstax_history_row['amount']);
    }
  }else{
    $code = DebitNote($conn);
    $id   = '';  
  }
  
?>
<style type="text/css">
  .add-more-table {
    border-radius: 0px !important;
    border-color: black !important;
    min-height: 38px !important;
    position: relative !important;
    top: 0px !important;
    border: none !important;
  }
  .red {
    position: relative !important;
    bottom: 2px !important;
  }
</style>
<section class="content-header">
  <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
        <h3 class="capital font15 padding5 bold"><?php echo ($id == 0) ? 'ADD NEW DEBIT NOTE' : 'UPDATE DEBIT NOTE'; ?></h3>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
        <h3>
          <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'vendor_list') ) { ?>
          <a href="index.php?page=debit_note/list.php" class="btn btn-danger capital bottom10 custome-btn">VIEW DEBIT NOTE DETAILS</a>
          <?php } ?>
        </h3>
      </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="hitz-top-header">
   <div class="row bottom40">
      <div class="col-xs-12">
         <div class="box box-success">
            <div class="box-body">
              <form action="debit_note/insert.php" method="post" enctype="multipart/form-data" class="common-frm-validation" id="signupForm">
                <div class="row">
                  <div class="col-sm-12">
                    <div class="col-md-5">
                      <div class="row">
                        <div class="col-md-4">
                          <div class="form-group">
                            <label class="capital">CODE</label><span class="error">*</span>
                            <input type="text" size="35" id="code" name="code" class="form-control required" autocomplete="off" readonly="" value="<?php echo $code;?>" autofocus="on"/>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <label class="capital">DATE</label><span class="error">*</span>
                            <div class="input-group date">
                              <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                              </div>
                              <input type="text" size="35" id="date" name="date" class="form-control date-picker" placeholder="DATE" autocomplete="off" value="<?php echo risFormatDate($date,'d-m-Y')?>" />
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div class="col-md-10">
                            <div class="form-group">
                              <label class="capital">SUPPLIER</label><span class="error">*</span>
                              <select class="form-control required select2" name="supplier_id" id="supplier_id">
                                <option value></option>
                                <?php 
                                foreach ($vdata as $vdatas) {
                                echo '<option value="'.$vdatas['id'].'" '.($vdatas['id'] == $supplier_id ? 'selected' : '').'>'.$vdatas['name'].'</option>';
                                } ?>
                              </select>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12">
                          <div class="col-md-10">
                            <div class="form-group">
                              <label class="capital">ADDRESS</label><span class="error">*</span>
                              <textarea class="form-control" name="address" id="address" style="height: 30% !important;" readonly="readonly" tabindex="-1"></textarea>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12">
                          <div class="col-md-10">
                            <div class="form-group">
                              <label class="capital">GST NO</label><span class="error">*</span>
                              <input type="text" class="form-control" name="gst_no" id="gst_no" autocomplete="off" readonly="readonly" tabindex="-1">
                            </div>
                          </div>
                        </div>
                        <div class="col-md-12">
                          <div class="col-md-10">
                            <div class="form-group">
                              <label class="capital">PANCARD</label><span class="error">*</span>
                              <input type="text" class="form-control" name="pancard_no" id="pancard_no" autocomplete="off" readonly="readonly" tabindex="-1">
                            </div>
                          </div>
                        </div>
                      </div>    
                    </div>
                    <div class="col-md-7">
                      <div class="row">
                        <div id="product-wapper">
                          <table class="table table-bordered table-responsive">
                            <thead>
                              <tr>
                                <th class="text-center" width="3%">#</th>
                                <th class="text-center">DESCRIPTION</th>
                                <th class="text-center" width="10%">HSN</th>
                                <th class="text-center" width="10%">QTY</th>
                                <th class="text-center" width="10%">RATE</th>
                                <th class="text-center" width="15%">AMOUNT</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php $tmp_cnt = 0; ?>
                              <?php if(isset($detail) && count($detail) > 0) { ?>
                              <?php foreach ($detail as $key => $detail_data) { ?>
                              <tr>
                                <td>
                                  <a href="javascript:;" class="btn red btn-block remove-me" style="display: block;"><i class="fa fa-minus"></i></a>
                                </td>
                                
                                <td>
                                  <input type="text" name="material[<?php echo $key ?>][description]" class="form-control description count add-more-table" autocomplete="off" data-count="<?php echo $key; ?>" value="<?php echo $detail_data['description']?>">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $key ?>][hsn]" class="form-control hsn count add-more-table number" autocomplete="off" value="<?php echo $detail_data['hsn']?>">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $key ?>][qty]" class="form-control qty count add-more-table" autocomplete="off" value="<?php echo $detail_data['qty']?>">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $key ?>][rate]" class="form-control rate count add-more-table" autocomplete="off" value="<?php echo $detail_data['rate']?>">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $key ?>][amount]" class="form-control amount count add-more-table" autocomplete="off" readonly="readonly" tabindex="-1" value="<?php echo $detail_data['amount']?>">
                                </td>
                              </tr>
                              <?php $tmp_cnt++; ?>
                              <?php } ?>  
                              <?php } ?>
                              <?php 
                              $tmp_for_loop = ( $tmp_cnt < 6 ) ? 6 : ($tmp_cnt + 1);
                              $last_med     = $tmp_for_loop - 1;
                              ?>
                              <?php for ($tmp_row_count = $tmp_cnt; $tmp_row_count < $tmp_for_loop; $tmp_row_count++) { ?>
                              <tr>
                                <td>
                                  <a href="javascript:;" class="btn green btn-block add-more" style="display: <?php echo ($tmp_row_count == $last_med) ? 'block' : 'none'; ?>"><i class="fa fa-plus"></i></a>
                                  <a href="javascript:;" class="btn red btn-block remove-me" style="display: <?php echo ($tmp_row_count == $last_med) ? 'none' : 'block'; ?>;"><i class="fa fa-minus"></i></a>
                                </td>
                                
                                <td>
                                  <input type="text" name="material[<?php echo $tmp_row_count ?>][description]" class="form-control description count add-more-table" autocomplete="off" data-count="<?php echo $tmp_row_count; ?>">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $tmp_row_count ?>][hsn]" class="form-control hsn count add-more-table number" autocomplete="off">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $tmp_row_count ?>][qty]" class="form-control qty count add-more-table" autocomplete="off">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $tmp_row_count ?>][rate]" class="form-control rate count add-more-table" autocomplete="off">
                                </td>

                                <td>
                                  <input type="text" name="material[<?php echo $tmp_row_count ?>][amount]" class="form-control amount count add-more-table" autocomplete="off" readonly="readonly" tabindex="-1">
                                </td>
                              </tr>
                              <?php } ?>
                            </tbody>  
                          </table>
                        </div>
                      </div>    
                    </div>
                  </div>
                </div>
                <legend class="hitz-legend">TAX DETAIL</legend>
                <div class="row">
                  <div class="col-md-4">
                    <div class="col-md-12" id="product-wappers">
                      <table class="table table-bordered">
                          <tbody>
                            <?php for ($i=1; $i <=4 ; $i++) { 
                            $tmp_add_tax_detail = array();
                            if(isset($add_tax[$i])) {
                              $tmp_add_tax_detail = $add_tax[$i];
                            }
                            if(@$tmp_add_tax_detail['amount'] > 0){
                              $style = '';
                            }else{
                              $style = 'readonly';
                            }
                            ?>
                             <tr>
                                <td>
                                  <select class="form-control chosen-select height29 hitz-add" name="add[<?php echo $i ?>][tax_mst_id]" >
                                      <option value></option>
                                      <?php foreach ($tax_rows as $tax_row) { ?>
                                        <option value="<?php echo $tax_row['id'];?>" <?php echo ($tax_row['id'] == $tmp_add_tax_detail['id']) ? 'selected' : ''; ?>><?php echo $tax_row['descr'];?></option>
                                      <?php } ?>
                                  </select>
                                </td>
                                <td width="30%;"><input type="text" name="add[<?php echo $i ?>][amount]" class="form-control hitz_add height29 payment-table number addition" data-count="<?php echo $i ?>" autocomplete="off" <?php echo $style;?> value="<?php echo @$tmp_add_tax_detail['amount'];?>"></td>
                             </tr>
                            <?php } ?>
                            
                          </tbody>
                       </table>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="col-md-12" id="sub-wapper">
                      <table class="table table-bordered">
                        <tbody>
                          <?php for ($i=1; $i <=4 ; $i++) { 
                          $tmp_less_tax_detail = array();
                          if(isset($less_tax[$i])) {
                            $tmp_less_tax_detail = $less_tax[$i];
                          }

                          if(@$tmp_less_tax_detail['amount'] > 0){
                            $style = '';
                          }else{
                            $style = 'readonly';
                          }
                          ?>
                          <tr>
                            <td>
                                <select class="form-control chosen-select height29 hitz-del payment-table" name="sub[<?php echo $i ?>][tax_mst_id]">
                                  <option value></option>
                                  <?php foreach ($d_tax_rows as $d_tax_row) { ?>
                                  <option value="<?php echo $d_tax_row['id'];?>" <?php echo ($d_tax_row['id'] == $tmp_less_tax_detail['id']) ? 'selected' : ''; ?>><?php echo $d_tax_row['descr'];?></option>
                                  <?php } ?>
                                </select>
                            </td>
                            
                            <td width="30%;"><input type="text" name="sub[<?php echo $i ?>][amount]" class="form-control hitz_subs height29 number payment-table deduction" data-count="<?php echo $i ?>" autocomplete="off" value="<?php echo @$tmp_less_tax_detail['amount'];?>" <?php echo $style;?>></td>
                          </tr>
                          <?php } ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="capital">GROSS AMOUNT</label>
                          <input type="text" size="35" id="gross_amount" name="gross_amount" class="form-control" autocomplete="off" readonly="" value="<?php echo $gross_amount;?>" />
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="capital">ADDITION</label>
                          <input type="text" size="35" id="addition" name="addition" class="form-control" autocomplete="off" readonly="" value="<?php echo $addition;?>"/>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="capital">DEDUCTION</label>
                          <input type="text" size="35" id="deduction" name="deduction" class="form-control" autocomplete="off" readonly="" value="<?php echo $deduction;?>"/>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="capital">CGST(%)</label>
                          <input type="text" size="35" id="cgst_per" name="cgst_per" class="form-control number" autocomplete="off" value="<?php echo $cgst_per;?>"/>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="capital">CGST(₹)</label>
                          <input type="text" size="35" id="cgst_amount" name="cgst_amount" class="form-control number" autocomplete="off" readonly="" value="<?php echo $cgst_amount;?>"/>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="capital">SGST(%)</label>
                          <input type="text" size="35" id="sgst_per" name="sgst_per" class="form-control number" autocomplete="off" value="<?php echo $sgst_per;?>"/>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="capital">SGST(₹)</label>
                          <input type="text" size="35" id="sgst_amount" name="sgst_amount" class="form-control number" autocomplete="off" readonly="" value="<?php echo $sgst_amount;?>"/>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="capital">IGST(%)</label>
                          <input type="text" size="35" id="igst_per" name="igst_per" class="form-control number" autocomplete="off" value="<?php echo $igst_per;?>"/>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="capital">IGST(₹)</label>
                          <input type="text" size="35" id="igst_amount" name="igst_amount" class="form-control number" autocomplete="off" readonly="" value="<?php echo $igst_amount;?>"/>
                        </div>
                      </div>
                      <div class="col-sm-6">
                        <div class="form-group">
                          <label class="capital">NET AMOUNT</label>
                          <input type="text" size="35" id="net_amount" name="net_amount" class="form-control" autocomplete="off" readonly value="<?php echo $net_amount;?>"/>

                          <input type="hidden" size="35" id="taxable_amount" name="taxable_amount" class="form-control" autocomplete="off" readonly value="<?php echo $taxable_amount;?>"/>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-sm-12">
                    <div class="form-group">
                      <label class="capital">remark</label>
                      <textarea class="form-control hit-textarea" autocomplete="off" name="remarks" id="remarks" style="height: 50px !important;"></textarea>
                    </div>
                  </div>
                </div>
                <input type="hidden" value="<?php echo $id;?>" name="id" id="id">
                <hr>
                <div class="row" align="center">
                  <button id="btn" class="btn btn-primary ajax-submit capital" type="submit"> <?php echo ($id == 0) ? 'Save & List' : 'Update & save'; ?></button>
                  <a href="index.php?page=emp_mst/list.php" class="btn btn-danger capital"> Cancel</a>
                </div>
              </form>
            </div>
         </div>
      </div>
   </div>
</section>
<div id="product-template" style="display:none;">
  <table>
    <tr>
      <td>
        <input type="text" name="material[%i%][description]" class="form-control description count add-more-table" autocomplete="off" data-count="%i%">
      </td>

      <td>
        <input type="text" name="material[%i%][hsn]" class="form-control hsn count add-more-table" autocomplete="off">
      </td>

      <td>
        <input type="text" name="material[%i%][qty]" class="form-control qty count add-more-table" autocomplete="off">
      </td>

      <td>
        <input type="text" name="material[%i%][rate]" class="form-control rate count add-more-table" autocomplete="off">
      </td>

      <td>
        <input type="text" name="material[%i%][amount]" class="form-control amount count add-more-table" autocomplete="off" readonly="readonly" tabindex="-1">
      </td>
    </tr>
  </table>
</div>
<script type="text/javascript">
jQuery(document).ready(function() {
  $id = jQuery('#id').val();
  if($id != ''){
    GetSupplierData();
  }

  jQuery(".chosen-select").chosen({disable_search_threshold: 1});
  jQuery('#supplier_id').select2();

  jQuery(document).on('change', '#supplier_id', function() {
    GetSupplierData();
  });

  jQuery(document).on('change', "#product-wapper .rate", function() {
    var $id = jQuery(this).closest('tr').find('.description').attr('data-count');
    calculate($id);
  });

  jQuery(document).on('change', '.hitz-add', function() {
    var $trs = jQuery(this).closest('tr').find('.addition').attr('data-count');
    jQuery('input[name="add[' + $trs + '][amount]"]').removeAttr("readonly", "readonly");
  });

  jQuery(document).on('change', '.hitz-del', function() {
    var $tr = jQuery(this).closest('tr').find('.deduction').attr('data-count');
    jQuery('input[name="sub[' + $tr + '][amount]"]').removeAttr("readonly", "readonly");
  });

  jQuery(document).on('keyup', '.hitz_add', function() {
    FinalCalculation();
  });

  jQuery(document).on('keyup', '.hitz_subs', function() {
    FinalCalculation();
  });

  jQuery(document).on('change', '#cgst_per', function() {
    GSTCalculation();
  });

  jQuery(document).on('change', '#igst_per', function() {
    GSTCalculation();
  });
});

function GetSupplierData(ele) {
  $customer_id = jQuery('#supplier_id').val();
  jQuery.ajax({
    'type': 'POST',
    'url': 'debit_note/get_supplier_data.php',
    'data': 'customer_id=' + $customer_id,
    dataType: 'JSON',
    success: function (result) {
      if (result != '') {
        jQuery('#address').val(result.address);
        jQuery('#pancard_no').val(result.pan);
        jQuery('#gst_no').val(result.gstin);
      }
    }
  });
}

function calculate($id){
  var $tr    = jQuery('input[name="material[' + $id + '][description]"]').closest('tr');

  var $qty = parseFloat($tr.find('.qty').val());
  if ($qty == '' || $qty == undefined || isNaN($qty)) {
    $qty = 0;
  }

  var $rate = parseFloat($tr.find('.rate').val());
  if ($rate == '' || $rate == undefined || isNaN($rate)) {
    $rate = 0;
  }

  var $amount = $qty * $rate;
  $tr.find('.amount').val($amount.toFixed(2));

  FinalCalculation();
}

function FinalCalculation() {
  var $product_wapper   = jQuery('#product-wapper').find('table tbody tr');
  var $addition_wappers = jQuery('#product-wappers').find('table tbody tr');
  var $deduction_wapper = jQuery('#sub-wapper').find('table tbody tr');

  $gross_amount = 0;
  $product_wapper.each(function(i, v) {
    $amount  = parseFloat(jQuery(v).find('.amount').val());
    if ($amount == '' || $amount == undefined || isNaN($amount)) {
      $amount = 0;
    }
    $gross_amount  += $amount;
  });

  var $addition_amount = 0;
  $addition_wappers.each(function(i, v) {
    $add_amnt  = parseFloat(jQuery(v).find('.hitz_add').val());
      if ($add_amnt == '' || $add_amnt == undefined || isNaN($add_amnt)) {
        $add_amnt = 0;
      }
    $addition_amount += $add_amnt;
  });
  $other_add  = $addition_amount;

  var $deduction_amount = 0;
  $deduction_wapper.each(function(i, v) {
    $less_amnt  = parseFloat(jQuery(v).find('.hitz_subs').val());
      if ($less_amnt == '' || $less_amnt == undefined || isNaN($less_amnt)) {
        $less_amnt = 0;
      }
    $deduction_amount += $less_amnt;
  });
  $other_less  = $deduction_amount;

  $taxable_amount = ($gross_amount + $other_add) - $other_less;
  jQuery('#gross_amount').val($gross_amount.toFixed(2));
  jQuery('#taxable_amount').val($taxable_amount.toFixed(2));
  jQuery('#net_amount').val($taxable_amount.toFixed(2));
  jQuery('#addition').val($other_add.toFixed(2));
  jQuery('#deduction').val($other_less.toFixed(2));
}

function GSTCalculation(argument) {
  var $gross_amount = parseFloat(jQuery('#gross_amount').val());
  if ($gross_amount == '' || $gross_amount == undefined || isNaN($gross_amount)) {
    $gross_amount = 0;
  }

  var $addition = parseFloat(jQuery('#addition').val());
  if ($addition == '' || $addition == undefined || isNaN($addition)) {
    $addition = 0;
  }

  var $deduction = parseFloat(jQuery('#deduction').val());
  if ($deduction == '' || $deduction == undefined || isNaN($deduction)) {
    $deduction = 0;
  }

  var $cgst_per = parseFloat(jQuery('#cgst_per').val());
  if ($cgst_per == '' || $cgst_per == undefined || isNaN($cgst_per)) {
    $cgst_per = 0;
  }

  var $igst_per = parseFloat(jQuery('#igst_per').val());
  if ($igst_per == '' || $igst_per == undefined || isNaN($igst_per)) {
    $igst_per = 0;
  }

  var $taxable_amount = ($gross_amount + $addition) - $deduction;

  if($cgst_per > 0){
    $cgst_amount   = ($cgst_per * $taxable_amount)/100;
    $sgst_amount   = ($cgst_per * $taxable_amount)/100;
    $net_amount    = $taxable_amount + $cgst_amount + $sgst_amount;

    jQuery('#cgst_amount').val($cgst_amount.toFixed(2));
    jQuery('#sgst_per').val($cgst_per.toFixed(2));
    jQuery('#sgst_amount').val($sgst_amount.toFixed(2));
    jQuery('#net_amount').val($net_amount.toFixed(2));
    jQuery('input[name="sgst_per"]').attr("readonly", "readonly");
    jQuery('input[name="igst_per"]').attr("readonly", "readonly");
  }else{
    $igst_amount   = ($igst_per * $taxable_amount)/100;
    $net_amount    = $taxable_amount + $igst_amount;
    jQuery('#igst_amount').val($igst_amount.toFixed(2));
    jQuery('#net_amount').val($net_amount.toFixed(2));
    jQuery('input[name="sgst_per"]').attr("readonly", "readonly");
    jQuery('input[name="cgst_per"]').attr("readonly", "readonly");
  }
}
</script>