  <?php 
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'lhc_list') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';
    die();
  }
?> 
<section class="content-header">
  <div class="row">
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
        <h3 class="capital font15 padding5 bold">VIEW LHC DETAILS</h3>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
        <h3>
        <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'lhc_add') ) { ?>
        <a href="index.php?page=lhc/add.php" class="btn btn-danger capital bottom10 custome-btn">Add New LHC</a>
        <?php } ?>
        </h3>
      </div>
  </div>
</section>

<hr class="bottom35"> 

<section class="hitz-top-header">
  <div class="card bottom40">
    <div class="card-body table-responsive">
      <table id="example1" class="table table-bordered table-striped list_data width100">
        <thead>
          <tr>
            <th width="15">NO.</th>
            <th width="55">LHC NO</th>
            <th width="70">LHC DATE</th>
            <th width="70">TRUCK NO</th>
            <th width="70">LR NO</th>
            <th width="70">FROM</th>
            <th width="70">TO</th>
            <th width="70">LORRY HIRE</th>
            <th width="70">ADVANCE</th>
            <th width="70">BALANCE</th>
            <th width="70">PAYMENT</th>
            <th width="100">CREATED BY</th>
            <th width="200">ACTION</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td colspan="13"><?php echo "NO RECORD FOUND"; ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</section>

<div id="dataModal" class="modal fade">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-body" id="employee_detail"></div>
      <div class="modal-footer hidden-print">  
        <label class="radio-inline fontradiobuttion">
        <input type="checkbox" ata-checkbox="icheckbox_flat" class="icheck" id="header-checkbox" checked=""> <span class="label-text">INCLUDE HEADER</span>
        </label>
        <button type="button" onclick="window.print();" class="btn btn-primary"><i class="fa fa-print" aria-hidden="true"></i></button> 
        <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-times-circle-o" aria-hidden="true"></i></button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  jQuery(document).ready(function() {
    loadDataTable();
  });
  
  function loadDataTable(){
      if(typeof dTable!='undefined'){dTable.fnDestroy();}
  
      dTable=jQuery('.list_data').dataTable({
          "bProcessing"       : true,
          "order"             : [ [1, 'desc'] ],
          "aLengthMenu"       : [ [5, 10, 15, 20, 25, 50, 100], [5, 10, 15, 20, 25, 50, 100] ],
          'iDisplayLength'    : 50,
          "aoColumns"         : [
              {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"} , {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"sClass": "text-center"}, {"bSortable": false, "sClass": "text-center"}
          ],
          "bServerSide"       : true,
          "sAjaxSource"       : 'lhc/fetch.php',
      });
  }
  
  function confirmDelete(e) {
    var $i = $(e).attr("id");
    console.log($i);
    swal({
        title: "Are you sure?",
        text: "You will not be able to recover this imaginary file!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, delete it!",
        closeOnConfirm: false
    }, function (isConfirm) {
        if (!isConfirm) return;
        $.ajax({
            url: "lhc/delete.php",
            type: "POST",
            data: 'delete='+$i,
            dataType: "json",
            success: function () {
              swal({title: "Deleted!", text: "Data successfully Deleted!", type: "success"},
                function(){ 
                  location.reload();
                }
              );

            },

            error: function (xhr, ajaxOptions, thrownError) {
              swal("Error deleting!", "Please try again", "error");  
            },
        });
    });
  } 

  function AdvancePrint(e){
    var $i = $(e).attr("id");
    $.ajax({  
      url:"lhc/advance_payment_print.php",  
      method:"post",  
      data:{id:$i},  
      success:function(data){  
        $('#employee_detail').html(data);  
        $('#dataModal').modal("show");  
      }  
    });
  }

  function BalancePrint(e){
    var $i = $(e).attr("id");
    $.ajax({  
      url:"lhc/balance_copy.php",  
      method:"post",  
      data:{id:$i},  
      success:function(data){  
        $('#employee_detail').html(data);  
        $('#dataModal').modal("show");  
      }  
    });
  }

  function get_payment_history(e){
    var $i = $(e).attr("id");
    $.ajax({  
      url:"lhc/balance_history_data.php",  
      method:"post",  
      data:{id:$i},  
      success:function(data){  
        $('#employee_detail').html(data);  
        $('#dataModal').modal("show");  
      }  
    });
  }

  function CancleFlag(e) {
    var $i = $(e).attr("id");
    swal({
        title: "Are you sure?",
        text: "You will not be able to recover this imaginary file!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes, Cancel it!",
        closeOnConfirm: false
    }, function (isConfirm) {
        if (!isConfirm) return;
        $.ajax({
            url: "lhc/cancel_flag.php",
            type: "POST",
            data: 'delete='+$i,
            dataType: "json",
            Error: function () {
              swal("Error canceling!", "Please try again", "error");
            },

            success: function (xhr, ajaxOptions, thrownError) {
              swal({title: "Canceled!", text: "Data successfully Canceled!", type: "success"},
                function(){ 
                  location.reload();
                }
              );
            }
        });
    });
  }
</script>