<?php
  if( !hasPermission($_SESSION['user_detail']['role_id'], 'lhc_balance_payment_add') ) {
    echo '<script>window.location.href="index.php?page=no_permission.php"</script>';die();
  }

  $lhc = mysqli_query($conn, "SELECT DISTINCT lhc_no FROM `lhc` WHERE balance > 0 order by lhc_no");
  $lhc_data = array();
  while ($rows = mysqli_fetch_assoc($lhc)) {
    $lhc_data[] = $rows;
  }

  $owner = mysqli_query($conn, "SELECT DISTINCT owner_name FROM `lhc` WHERE balance > 0 AND owner_name != '' order by owner_name");
  $owner_data = array();
  while ($rows = mysqli_fetch_assoc($owner)) {
    $owner_data[] = $rows;
  }

  $agent = mysqli_query($conn, "SELECT DISTINCT agent FROM `lhc` WHERE balance > 0 AND agent != '' order by agent");
  $agent_data = array();
  while ($agent_rows = mysqli_fetch_assoc($agent)) {
    $agent_data[] = $agent_rows;
  }
  $master_owner = combine(getAllRecords('truck_mst'), 'id', 'o_name');
?>
<section class="content-header">
  <div class="row">
    <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 bottom20">
      <h3 class="capital font15 padding5 bold">ADD NEW LHC BALANCE PAYMENT</h3>
    </div>
    <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-right bottom20">
      <h3>
        <?php if( hasPermission($_SESSION['user_detail']['role_id'], 'tr_list') ) { ?>
        <a href="index.php?page=lhc_balance_payment/list.php" class="btn btn-danger capital bottom10 custome-btn">VIEW LHC BALANCE PAYMENT</a>
        <?php } ?>

        
      </h3>
    </div>
  </div>
</section>
<hr class="bottom35"> 
<section class="content-header bottom40">
  <div class="row hitz-report">
    <form action="lhc_balance_payment/insert.php" method="post" enctype="multipart/form-data" class="common-frm-validation" id="signupForm" name="signupForm">
        
      <div class="card-body table-responsive">
        <div class="col-md-12">
          <div class="col-md-4">
            <div class="form-group">
              <label class="capital">OWNER</label>
              <select class="form-control select2" name="owner_name" id="owner_name" style="width:100%; height:28px !important;">
                <option value>ALL</option>
                <?php foreach ($owner_data as $key => $owner_datas) { ?>
                <option value="<?php echo $owner_datas['owner_name']?>"><?php echo @$master_owner[$owner_datas['owner_name']]?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          
          <div class="col-md-4">
            <div class="form-group">
              <label class="capital">AGENT</label>
              <select class="form-control select2" name="agent_name" id="agent_name" style="width:100%; height:28px !important;">
                <option value>ALL</option>
                <?php foreach ($agent_data as $key => $agent_datas) { ?>
                <option value="<?php echo $agent_datas['agent']?>"><?php echo $agent_datas['agent']?></option>
                <?php } ?>
              </select>
            </div>
          </div>

          <div class="col-md-4">
            <div class="form-group">
              <label class="capital">LHC NO</label>
              <select class="form-control select2" name="lhc_no" id="lhc_no" style="width:100%; height:28px !important;">
                <option value>ALL</option>
                <?php foreach ($lhc_data as $key => $lhc_datas) { ?>
                <option value="<?php echo $lhc_datas['lhc_no']?>"><?php echo $lhc_datas['lhc_no']?></option>
                <?php } ?>
              </select>
            </div>
          </div>

        </div>
        
        
        <div class="col-md-12">
          <div class="col-md-1">
            <div class="form-group">
               <label class="capital">LHC NO</label><span style="color: red">*</span>
               <input type="text" size="40" id="code" name="code" class="form-control lr_number" autocomplete="off" placeholder="LHC NO" onChange="CheckLhc(this.value);" value="<?php echo LhcBalance($conn);?>" readonly="" autofocus=""/>
            </div>
          </div>
          <div class="col-md-2">
            <div class="form-group">
               <label class="capital">DATE</label><span style="color: red">*</span>
               <div class="input-group date">
                  <div class="input-group-addon">
                     <i class="fa fa-calendar"></i>
                  </div>
                  <input type="text" size="35" id="date" name="date" class="form-control date-picker" placeholder="DATE" autocomplete="off" value="<?php echo date('d-m-Y')?>" />
               </div>
            </div>
          </div>
        </div>
        <div class="col-lg-12 scroll-table-container" id="lhc-wapper">
          <table class="table table-bordered table-striped list_data width100">
            <thead>
              <tr>
                <th class="text-center" width="0.3%" style="font-size:10px;">SR.NO</th>
                <th class="text-center" width="3.5%" style="font-size:10px;">LHC</th>
                <th class="text-center" width="3%" style="font-size:10px;">DATE</th>
                <th class="text-center" width="3%" style="font-size:10px;">TRUCK</th>
                <th class="text-center" width="3.5%" style="font-size:10px;">FROM</th>
                <th class="text-center" width="3.5%" style="font-size:10px;">TO</th>
                <th class="text-center" width="4%" style="font-size:10px;">AGENT</th>
                <th class="text-center" width="4%" style="font-size:10px;">OWNER</th>
                <th class="text-center" width="2%" style="font-size:10px;">LORRY HIRE</th>
                <th class="text-center" width="2%" style="font-size:10px;">ADVANCE TO BE PAID</th>
                <th class="text-center" width="2%" style="font-size:10px;">PAID</th>
                <th class="text-center" width="2%" style="font-size:10px;">PENDING</th>
                <th class="text-center" width="2%" style="font-size:10px;">OTHER ADD</th>
                <th class="text-center" width="2%" style="font-size:10px;">OTHER LESS</th>
                <th class="text-center" width="2%" style="font-size:10px;">TOTAL PENDING</th>
                <th class="text-center" width="2%" style="font-size:10px;">ADJUST</th>
                <th class="text-center" width="2.5%" style="font-size:10px;">PAID TO</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
        <div class="col-lg-12">
          <legend class="hitz-legend">PAYMENT DETAIL</legend>
          <div class="col-md-12">
            <div class="col-md-2">
              <div class="form-group">
                <label class="capital">TOTAL</label><span class="error">*</span>
                <input type="text" size="35" id="total_amount" name="total_amount" class="form-control lorry-hire required" autocomplete="off" placeholder="TOTAL AMOUNT" readonly="readonly"/>
              </div>
            </div>
            <div class="col-md-5">
              <div class="row" id="cash-wrapper">
                <div class="col-md-2">
                  <div class="form-group">
                    <label class="radio-inline fontradiobuttion">
                    <input type="radio" name="payment_type[]" value="C" class="hit-cash"> <span class="label-text">CASH</span>
                    </label>
                  </div>
                </div>
                <div class="col-md-5">
                  <label>AMOUNT</label>
                  <div class="form-group">
                    <input type="text" name="cash"  id="cash" class="form-control developer payment_amount" autocomplete="off" onchange="CheckCashAct(this);"/>
                  </div>
                </div>
                <div class="col-md-5">
                  <label>NAME</label>
                  <div class="form-group">
                    <select name="cash_name" id="cash_name" class="form-control at-cash select2" style="width: 100%">
                    <option></option>
                    <?php 
                     $truck     = "SELECT * FROM `act_master` WHERE `account_group` ='CASH'";
                     $truck_res = mysqli_query($conn,$truck);
                     while ($truck_row=mysqli_fetch_array($truck_res)) { ?>f
                    <option value="<?php echo $truck_row['id']?>"><?php echo $truck_row['ac_name']?></option>
                    <?php } ?>
                    </select>
                  </div>
                </div>
              </div>
              <div class="row" id="bank-wrapper">
                <div class="col-md-2">
                  <div class="form-group">
                    <label class="radio-inline fontradiobuttion">
                    <input type="radio" name="payment_type[]" value="B" class="hit-bank"> <span class="label-text">BANK</span>
                    </label>
                  </div>
                </div>
                <div class="col-md-5">
                  <label>AMOUNT</label>
                  <div class="form-group">
                    <input type="text" name="pay_mode_amnt" autocomplete= "off"  id="pay_mode_amnt" class="form-control developer" autocomplete="off"/>
                  </div>
                </div>
                <div class="col-md-5">
                  <label>MODE</label>
                  <div class="form-group">
                    <select name="payment_mode" id="payment_mode" class="form-control hit-payment_mode select2">
                      <option value=""></option>
                      <option value="CHEQUE">CHEQUE</option>

                      <option value="NEFT">NEFT</option>

                      <option value="IMPS">IMPS</option>

                      <option value="RTGS">RTGS</option>
                    </select>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-5">
              <div class="col-lg-6" id="imps_number_div" style="display:none">
                <div class="form-group">
                   <label class="capital">IMPS Transaction Number</label><span style="color: red"><sup>*</sup></span>
                   <input type="text" name="imps_number"  id="imps_number" class="form-control" autocomplete="off" />
                </div>
              </div>
              <div class="col-lg-6" id="rtgs_number_div" style="display:none">
                <div class="form-group">
                   <label class="capital">RTGS Transaction Number</label><span style="color: red"><sup>*</sup></span>
                   <input type="text" name="rtgs_number"  id="rtgs_number" class="form-control" autocomplete="off"/>
                </div>
              </div>
              <div class="col-lg-6" id="neft_number_div" style="display:none">
                <div class="form-group">
                   <label class="capital">NEFT Transaction Number</label><span style="color: red"><sup>*</sup></span>
                   <input type="text" name="neft_number"  id="neft_number" class="form-control" autocomplete="off"/>
                </div>
              </div>
              <div class="col-lg-6" id="cheque_number_div" style="display:none">
                <div class="form-group">
                   <label class="capital">Enter Cheque Number</label><span style="color: red"><sup>*</sup></span>
                   <input type="text" name="cheque_number"  id="cheque_number" class="form-control" autocomplete="off"/>
                </div>
              </div>
              <div class="col-lg-6" id="cheque_date_div" style="display:none">
                <div class="form-group">
                   <label class="capital">Enter Cheque Date</label>
                   <input type="text" name="cheque_date" autocomplete= "off"  id="cheque_date" class="form-control date-picker" autocomplete="off"/>
                </div>
              </div>
              <div class="col-lg-6" id="bank_name_div" style="display:none">
                <div class="form-group">
                   <label class="capital">Bank Name</label>
                   <select name="bank_name" id="bank_name" class="form-control at-bank select2" style="width: 100%">
                      <option></option>
                      <?php 
                         $truck     = "SELECT * FROM `act_master` WHERE `account_group` ='BANK'";
                         $truck_res = mysqli_query($conn,$truck);
                         while ($truck_row=mysqli_fetch_array($truck_res)) { ?>f
                      <option value="<?php echo $truck_row['id']?>"><?php echo $truck_row['ac_name']?></option>
                      <?php } ?>
                   </select>
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group">
                  <label class="capital">PAYMENT DATE</label><span style="color: red">*</span>
                  <div class="input-group date">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i>
                    </div>
                    <input type="text" size="35" id="payment_date" name="payment_date" class="form-control date-picker required" autocomplete="off" placeholder="PAYMENT DATE" value="<?php echo date('d-m-Y')?>" />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-12">
        <input type="hidden" value="LHC BALANCE PAYMENT" name="module" id="module">
        <input type="hidden" value="<?php echo $_GET['eid'];?>" name="id" id="id">
        <hr>
        <div class="row" align="center">
          <button id="btn" class="btn btn-primary ajax-submit capital" type="submit"> SAVE & LIST</button>
          <a href="index.php?page=lhc_balance_payment/list.php" class="btn btn-danger capital"> Cancel</a>
        </div>
        </div>
      </div>
    </form>
  </div>
</section>
<div class="modal right fade" id="search" role="dialog" aria-labelledby="myModalLabel2">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <form method="post">
          <div class="col-md-12">
            <div class="form-group">
              <label class="capital">DATE</label><span style="color: red">*</span>
              <div class="input-group date">
                <div class="input-group-addon">
                   <i class="fa fa-calendar"></i>
                </div>
                <input type="text" size="35" id="start_date" name="start_date" class="form-control date-picker" placeholder="DATE" autocomplete="off"/>
              </div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label class="capital">DATE</label><span style="color: red">*</span>
              <div class="input-group date">
                <div class="input-group-addon">
                   <i class="fa fa-calendar"></i>
                </div>
                <input type="text" size="35" id="end_date" name="end_date" class="form-control date-picker" placeholder="DATE" autocomplete="off"/>
              </div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label class="capital">OWNER</label>
              <select class="form-control select2" name="owner_name" id="owner_name" style="width:100%">
                <option value>ALL</option>
                <?php foreach ($owner_data as $key => $owner_datas) { ?>
                <option value="<?php echo $owner_datas['owner_name']?>"><?php echo @$master_owner[$owner_datas['owner_name']]?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label class="capital">AGENT</label>
              <select class="form-control select2" name="agent_name" id="agent_name" style="width:100%">
                <option value>ALL</option>
                <?php foreach ($agent_data as $key => $agent_datas) { ?>
                <option value="<?php echo $agent_datas['agent']?>"><?php echo $agent_datas['agent']?></option>
                <?php } ?>
              </select>
            </div>
          </div>

          <div class="col-md-12">
            <div class="form-group">
              <label class="capital">LHC NO</label>
              <select class="form-control select2" name="lhc_no" id="lhc_no" style="width:100%">
                <option value>ALL</option>
                <?php foreach ($lhc_data as $key => $lhc_datas) { ?>
                <option value="<?php echo $lhc_datas['lhc_no']?>"><?php echo $lhc_datas['lhc_no']?></option>
                <?php } ?>
              </select>
            </div>
          </div>

          <div class="col-md-12 top10">
            <button type="button" class="btn btn-danger aterp-custome-btn top10" id="btn-genrate">SEARCH</button>
          </div>
        </form>   
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
jQuery(document).ready(function() {
  jQuery('#owner_name').select2();
  jQuery('#agent_name').select2();
  jQuery('#lhc_no').select2();
  
  GetData();
  jQuery(document).on('change', '#agent_name', function(e){
    GetData();
  });
  jQuery(document).on('change', '#owner_name', function(e){
    GetData();
  });
  jQuery(document).on('change', '#lhc_no', function(e){
    GetData();
  });

  jQuery('#payment_mode').on('change', function() {
    if (this.value == 'CASH') {
      jQuery("#cash_div").show();
      jQuery("#cheque_date_div").hide();
      jQuery("#cheque_deposite_div").hide();
      jQuery("#bank_name_div").hide();
      jQuery("#bank_branch_div").hide();
      jQuery("#cheque_status_div").hide();
      jQuery("#neft_number_div").hide();
      jQuery("#rtgs_number_div").hide();
      jQuery("#imps_number_div").hide();
      jQuery("#amount_div").show();
    } else if (this.value == 'CHEQUE') {
      jQuery("#cheque_number_div").show();
      jQuery("#cheque_date_div").show();
      jQuery("#cheque_deposite_div").show();
      jQuery("#bank_name_div").show();
      jQuery("#bank_branch_div").show();
      jQuery("#cheque_status_div").show();
      jQuery("#neft_number_div").hide();
      jQuery("#rtgs_number_div").hide();
      jQuery("#imps_number_div").hide();
      jQuery("#cash_div").hide();
      jQuery("#amount_div").show();      
    } else if (this.value == 'NEFT'){
      jQuery("#neft_number_div").show();
      jQuery("#rtgs_number_div").hide();
      jQuery("#imps_number_div").hide();
      jQuery("#cheque_date_div").hide();
      jQuery("#cheque_deposite_div").hide();
      jQuery("#bank_name_div").show();
      jQuery("#bank_branch_div").hide();
      jQuery("#cheque_status_div").hide();
      jQuery("#cheque_number_div").hide();
      jQuery("#rtgs_number").val('');
      jQuery("#cheque_number").val('');
      jQuery("#cheque_date").val('');
      jQuery("#bank_name").val('').trigger('change');
      jQuery("#bank_branch").val('');
      jQuery("#cheque_status").val('');
      jQuery("#cash_div").hide();
      jQuery("#amount_div").show();
    } else if (this.value == 'RTGS'){
      jQuery("#rtgs_number_div").show();
      jQuery("#neft_number_div").hide();
      jQuery("#imps_number_div").hide();
      jQuery("#cheque_date_div").hide();
      jQuery("#cheque_deposite_div").hide();
      jQuery("#bank_name_div").show();
      jQuery("#bank_branch_div").hide();
      jQuery("#cheque_status_div").hide();
      jQuery("#cheque_number_div").hide();
      jQuery("#neft_number").val('');
      jQuery("#cheque_number").val('');
      jQuery("#cheque_date").val('');
      jQuery("#bank_name").val('').trigger('change');
      jQuery("#bank_branch").val('');
      jQuery("#cheque_status").val('');
      jQuery("#cash_div").hide();
      jQuery("#amount_div").show();
    } else if (this.value == 'IMPS'){
      jQuery("#imps_number_div").show();
      jQuery("#rtgs_number_div").hide();
      jQuery("#neft_number_div").hide();
      jQuery("#cheque_date_div").hide();
      jQuery("#cheque_deposite_div").hide();
      jQuery("#bank_name_div").show();
      jQuery("#bank_branch_div").hide();
      jQuery("#cheque_status_div").hide();
      jQuery("#cheque_number_div").hide();
      jQuery("#rtgs_number").val('');
      jQuery("#neft_number").val('');
      jQuery("#cheque_number").val('');
      jQuery("#cheque_date").val('');
      jQuery("#bank_name").val('').trigger('change');
      jQuery("#bank_branch").val('');
      jQuery("#cheque_status").val('');
      jQuery("#cash_div").hide();
      jQuery("#amount_div").show();
    } else if (this.value == 'DD') {
      jQuery("#cheque_number_div").show();
      jQuery("#cheque_date_div").show();
      jQuery("#cheque_deposite_div").show();
      jQuery("#bank_name_div").show();
      jQuery("#bank_branch_div").show();
      jQuery("#cheque_status_div").show();
      jQuery("#neft_number_div").hide();
      jQuery("#rtgs_number_div").hide();
      jQuery("#imps_number_div").hide();
      jQuery("#cash_div").hide();
      jQuery("#amount_div").show();
    } else {
      jQuery("#payment_collection_date").val('');
      jQuery("#imps_number_div").hide();
      jQuery("#imps_number").val('');
      jQuery("#rtgs_number_div").hide();
      jQuery("#rtgs_number").val('');
      jQuery("#neft_number_div").hide();
      jQuery("#neft_number").val('');
      jQuery("#cheque_number_div").hide();
      jQuery("#cheque_number").val('');
      jQuery("#cheque_date_div").hide();
      jQuery("#cheque_deposite_div").hide();
      jQuery("#cheque_date").val('');
      jQuery("#bank_name_div").hide();
      jQuery("#bank_name").val('').trigger('change');
      jQuery("#bank_branch_div").hide();
      jQuery("#bank_branch").val('');
      jQuery("#cheque_status_div").show();
      jQuery("#cheque_status").val('');
      jQuery("#cash_div").hide();
      jQuery("#amount_div").show();
    }
  });

  jQuery(document).on('keyup', "#lhc-wapper .adjust_amount", function() {
    var $id = jQuery(this).closest('tr').find('.sr_no').attr('data-count');
    CheckPoint($id);
  });

  jQuery(document).on('change', "#lhc-wapper .other_add_amount", function() {
    var $id = jQuery(this).closest('tr').find('.sr_no').attr('data-count');
    CheckPoint($id);
  });

  jQuery(document).on('change', "#lhc-wapper .other_less_amount", function() {
    var $id = jQuery(this).closest('tr').find('.sr_no').attr('data-count');
    CheckPoint($id);
  });

  jQuery('.payment_amount').on('change', function() {
    var $total_amount = parseFloat(jQuery('#total_amount').val());
    if ($total_amount == '' || $total_amount == undefined || isNaN($total_amount)) {
      $total_amount = 0;
    }

    var $cash = parseFloat(jQuery('#cash').val());
    if ($cash == '' || $cash == undefined || isNaN($cash)) {
      $cash = 0;
    }

    var $bank = parseFloat(jQuery('#pay_mode_amnt').val());
    if ($bank == '' || $bank == undefined || isNaN($bank)) {
      $bank = 0;
    }

    var $bank_amount = $total_amount - $cash;
    
    if($cash > 0) {
      jQuery('.hit-cash').prop("checked", true).iCheck('update');
      jQuery('.at-cash').addClass('required');
      jQuery('#bank-wrapper').show();
    }else{
      jQuery('.hit-cash').prop("checked", false).iCheck('update');
      jQuery('.at-cash').removeClass('required');
      jQuery('#bank-wrapper').show();
    }

    if($bank_amount > 0) {
      jQuery('.hit-bank').prop("checked", true).iCheck('update');
      jQuery('.at-bank').addClass('required');
      jQuery('.hit-payment_mode').addClass('required');
      jQuery('#cash-wrapper').show();
    }else{
      jQuery('.hit-bank').prop("checked", false).iCheck('update');
      jQuery('.at-bank').removeClass('required');
      jQuery('.hit-payment_mode').removeClass('required');
      jQuery('#cash-wrapper').show();
    }

    if($bank < $cash){
      jQuery('.payment_amount').addClass('max-validation').attr('max',$total_amount); 
    }else{
      jQuery('.payment_amount').removeClass('max-validation');
    }

    jQuery('#pay_mode_amnt').val($bank_amount);
  });
});

function GetData(){
  $url = "lhc_balance_payment/get_data.php"+ '?start_date=' + jQuery('#start_date').val() + '&end_date=' + jQuery('#end_date').val() + '&agent_name=' + jQuery('#agent_name').val() + '&owner_name=' + jQuery('#owner_name').val() + '&lhc_no=' + jQuery('#lhc_no').val();

  jQuery.ajax({
    type: 'GET',
    url:  $url,
    dataType : 'JSON',
    beforeSend:function(){
      jQuery('#lhc-wapper tbody').html('<tr><td colspan="15" class="text-center"><i class="fa fa-2x fa-spin fa-spinner"></i> Loading Data....</td></tr>');
    },
    success: function(data) {
      if(data.status == 'success') {
        if(data.tbody != '') {
          jQuery('#lhc-wapper tbody').html(data.tbody);
        } else {
          jQuery('#lhc-wapper tbody').html('<tr><td colspan="2" class="text-center">No Data found to show !!</td></tr>');
        }
      }else{
        jQuery('#lhc-wapper tbody').html('<tr><td colspan="2" class="text-center">No Data found to show !!</td></tr>');
      }
    }
  }); 
}

function CheckPoint($id){
  var $tr = jQuery('input[name="lhc[' + $id + '][sr_no]"]').closest('tr');

  var $other_add_amount = parseFloat($tr.find('.other_add_amount').val());
  if ($other_add_amount == '' || $other_add_amount == undefined || isNaN($other_add_amount)) {
    $other_add_amount = 0;
  }

  var $other_less_amount = parseFloat($tr.find('.other_less_amount').val());
  if ($other_less_amount == '' || $other_less_amount == undefined || isNaN($other_less_amount)) {
    $other_less_amount = 0;
  }

  var $balance = parseFloat($tr.find('.balance').val());
  if ($balance == '' || $balance == undefined || isNaN($balance)) {
    $balance = 0;
  }

  var $adjust_amount = parseFloat($tr.find('.adjust_amount').val());
  if ($adjust_amount == '' || $adjust_amount == undefined || isNaN($adjust_amount)) {
    $adjust_amount = 0;
  }

  var $bank_amount = parseFloat(jQuery('#pay_mode_amnt').val());
  if ($bank_amount == '' || $bank_amount == undefined || isNaN($bank_amount)) {
    $bank_amount = 0;
  }
    
  if($bank_amount > 0) {
    jQuery('.hit-bank').prop("checked", true).iCheck('update');
    jQuery('.at-bank').addClass('required');
    jQuery('.hit-payment_mode').addClass('required');
  }else{
    jQuery('.hit-bank').prop("checked", false).iCheck('update');
    jQuery('.at-bank').removeClass('required');
    jQuery('.hit-payment_mode').removeClass('required');
  }
  FinalAmount();
  $last_balance  = parseFloat($tr.find('.last_balance').val());
    if ($last_balance == '' || $last_balance == undefined || isNaN($last_balance)) {
      $last_balance = 0;
    }
    
    $last_balance = (($other_add_amount + $balance) - ($other_less_amount));
    $tr.find('.last_balance').val($last_balance.toFixed(2));

  if($last_balance < $adjust_amount){
    $tr.find('.adjust_amount').addClass('max-validation').attr('max',$last_balance);
  }else{
    $tr.find('.adjust_amount').removeClass('max-validation');
  }
}

function FinalAmount(){
  var $placeorder_wapper   = jQuery('#lhc-wapper').find('table tbody tr');
  var $total_adjust_amount = 0;

  $placeorder_wapper.each(function(i, v) {
    $adjust_amount  = parseFloat(jQuery(v).find('.adjust_amount').val());
    if ($adjust_amount == '' || $adjust_amount == undefined || isNaN($adjust_amount)) {
      $adjust_amount = 0;
    }
    $total_adjust_amount  += $adjust_amount;

    $other_add_amount  = parseFloat(jQuery(v).find('.other_add_amount').val());
    if ($other_add_amount == '' || $other_add_amount == undefined || isNaN($other_add_amount)){
      $other_add_amount = 0;
    }

    $other_less_amount  = parseFloat(jQuery(v).find('.other_less_amount').val());
    if ($other_less_amount == '' || $other_less_amount == undefined || isNaN($other_less_amount)) {
      $other_less_amount = 0;
    }

    $balance  = parseFloat(jQuery(v).find('.balance').val());
    if ($balance == '' || $balance == undefined || isNaN($balance)) {
      $balance = 0;
    }
  });

  jQuery('#total_amount').val($total_adjust_amount.toFixed(2));
  jQuery('#pay_mode_amnt').val($total_adjust_amount.toFixed(2));
  /*jQuery('.hit-bank').prop("checked", true).iCheck('update');*/
}

function CheckCashAct(ele){
  $.ajax({
    'type': 'POST',
    'url': 'lhc/check_cash_act.php',
    dataType: 'JSON',
    success: function (result) {
      if(result.status == 0) {
        swal("Opps !!", "ACCOUNT NOT DETECT...!!!", "info")
      }else{
        jQuery('.submit').attr('enable', true);
      }
    }
  });
}
</script>

