<?php
// Include your database connection file
include("../config.php");

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["consignee_name"])) {
    // Sanitize the input
    $consigneeName = mysqli_real_escape_string($conn, $_POST["consignee_name"]);

    // Query to fetch consignor details based on name
    $query = "SELECT * FROM vendor_master WHERE name = '$consigneeName'";
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        // Consignee found, fetch the data
        $consigneeData = mysqli_fetch_assoc($result);

        // Prepare data to send back as JSON
        $response = array(
            'address' => $consigneeData['address'],
            'city' => $consigneeData['city'],
            'contact' => $consigneeData['contact'],
            'pan' => $consigneeData['pan'],
            'gst' => $consigneeData['gstin']
        );

        // Send the response as JSON
        echo json_encode($response);
    } else {
        // Consignor not found
        echo json_encode(array('error' => 'Consignee not found'));
    }
} else {
    // Invalid request
    echo json_encode(array('error' => 'Invalid request'));
}

// Close the connection
mysqli_close($conn);
?>
