<?php
// Include your database connection file
include("../config.php");

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["consignor_name"])) {
    // Sanitize the input
    $consignorName = mysqli_real_escape_string($conn, $_POST["consignor_name"]);

    // Query to fetch consignor details based on name
    $query = "SELECT * FROM vendor_master WHERE name = '$consignorName'";
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        // Consignor found, fetch the data
        $consignorData = mysqli_fetch_assoc($result);

        // Prepare data to send back as JSON
        $response = array(
            'address' => $consignorData['address'],
            'city' => $consignorData['city'],
            'contact' => $consignorData['contact'],
            'pan' => $consignorData['pan'],
            'gst' => $consignorData['gstin']
        );

        // Send the response as JSON
        echo json_encode($response);
    } else {
        // Consignor not found
        echo json_encode(array('error' => 'Consignor not found'));
    }
} else {
    // Invalid request
    echo json_encode(array('error' => 'Invalid request'));
}

// Close the connection
mysqli_close($conn);
?>
