<?php 
require_once '../assets/plugins/tcpdf/tcpdf.php'; 
include("../config.php");

class MyCustomPDFWithWatermark extends TCPDF {

    public function Header() {

      $bMargin = $this->getBreakMargin();

      $auto_page_break = $this->AutoPageBreak;

      $this->SetAutoPageBreak(false, 0);


       global $img_file; // Use global to dynamically set per page
        if (!empty($img_file)) {
            $this->Image($img_file, 0, 0, 0, 0, '', '', '', false, 300, '', false, false, 0);
        }
        $img_files = '../assets/logo/watermark_mc.png';
       $this->Image($img_files, 90, 55, 100, 100, '', '', '', false, 300,'', false, false, 0);
      $this->SetAutoPageBreak($auto_page_break, $bMargin);

      $this->setPageMark();

    }

}
$pdf = new MyCustomPDFWithWatermark(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->SetMargins(10,5,10);
$pdf->SetAutoPageBreak(TRUE, 0);

$pdf->SetFont('helvetica', '', '8.5', '', true);

$bill_no    = $_POST['lr_no'];
$file_type  = implode(",", $_POST['print_type']);
$arrays     = explode(',', $file_type);
$freight  = implode(",", $_POST['freight']);
$array     = explode(',', $freight);

$lr  = mysqli_query($conn,"SELECT * FROM `lr_mst` WHERE `lr_no` = '".$bill_no."' AND branch_id = '".$_SESSION['branch_id']."' AND company_id = '".$_SESSION['company_id']."'");
$lr_row = mysqli_fetch_assoc($lr);

$party_invoice = $lr_row['party_invoice'];
$bank_det       = "SELECT * FROM company_mst WHERE id = '".$_SESSION['company_id']."'";
$bank_det_res   = mysqli_query($conn,$bank_det);
$bank_det_rows  = mysqli_fetch_assoc($bank_det_res);

$cnor           = "SELECT * FROM vendor_master WHERE id = '".$lr_row['consignor_name']."'";
$cnor_res       = mysqli_query($conn,$cnor);
$cnor_row       = mysqli_fetch_assoc($cnor_res);

$consignor_name = $cnor_row['name'];
$consignor_address = $cnor_row['address']; 
$consignor_mobile = $cnor_row['mobile']; 
$consignor_state = $cnor_row['state']; 
$consignor_gstin = $cnor_row['gstin']; 
$consignor_pin = $cnor_row['pincode'];
$consignor_city = $cnor_row['city'];

$cnee           = "SELECT * FROM vendor_master WHERE id = '".$lr_row['consignee_name']."'";
$cnee_res       = mysqli_query($conn,$cnee);
$cnee_row       = mysqli_fetch_assoc($cnee_res);

$consignee_name = $cnee_row['name'];
$consignee_address = $cnee_row['address']; 
$consignee_mobile = $cnee_row['mobile']; 
$consignee_state = $cnee_row['state']; 
$consignee_gstin = $cnee_row['gstin']; 
$consignee_pin = $cnee_row['pincode'];
$consignee_city = $cnee_row['city'];


$bill_to        = mysqli_query($conn,"SELECT * FROM vendor_master WHERE id = '".$lr_row['billing_to']."'");
$bill_to_row    = mysqli_fetch_assoc($bill_to);

$truck_data     = mysqli_query($conn,"SELECT * FROM `truck_mst` WHERE `truck_no` = '".$lr_row['truck_no']."'");
$truck_mst_row  = mysqli_fetch_assoc($truck_data);

$master_vendor = combine(getAllRecords('vendor_master'), 'id', 'name');

if($lr_row['gst_paid_by'] == 'CONSIGNOR'){
   $gst_paid_by = 'CONSIGNOR';
}elseif ($lr_row['gst_paid_by'] == 'CONSIGNEE') {
   $gst_paid_by = 'CONSIGNEE';
}else{
   $gst_paid_by = $bill_to_row['name'];
}


if($truck_mst_row['up_to'] == '1970-01-01' || $truck_mst_row['up_to'] == ''){
 $up_to = '';
}else{
 $up_to = risFormatDate($truck_mst_row['up_to']);
}


if($lr_row['rate_on'] == 'TO BE BILLED'){
   $rateon = ' VADODARA';
}else{
   $rateon = $lr_row['rate_on'];
}


if($lr_row['party_amount'] == 0){
   $partyamount = ' AS PER INVOICE';
}else{
   $partyamount = $lr_row['party_amount'];
}


foreach ($arrays as $key => $print_types) {
    $output = ''; 
    if($print_types == 'nor_copy'){
        $lr_copy = 'CONSIGNOR COPY';
        $tag = "";
        $img_file = '';
    }

    if($print_types == 'nee_copy'){
        $lr_copy = 'CONSIGNEE COPY';
        $tag = "C.C ATTECHED";
      $img_file = '../assets/logo/light_green.png';

    }

    if($print_types == 'dri_copy'){
        $lr_copy = 'DRIVER COPY';
        $tag = "";
      $img_file = '../assets/logo/yellow.png';

    }

    if($print_types == 'ofc_copy'){
        $lr_copy = 'OFFICE COPY';
        $tag = "";
      $img_file = '../assets/logo/light_blue.png';

    }

    if($print_types == 'd_copy'){
        $lr_copy = 'DUPLICATE COPY';
        $tag = "";
      $img_file = '../assets/logo/light_pink.png';

    }

$bank_det       = "SELECT * FROM company_mst WHERE id = '".$_SESSION['company_id']."'";
$bank_det_res   = mysqli_query($conn,$bank_det);
$bank_det_rows  = mysqli_fetch_assoc($bank_det_res);

$lr_date = $lr_row['l_date'];
$from_place = $lr_row['from_place'];
$to_place = $lr_row['to_place'];
$address_delivery = $lr_row['address_delivery'];
$packing = $lr_row['packing']; 
$actual_weight = $lr_row['actual_weight']; 
$weight = $lr_row['weight']; 
$charged_weight = $lr_row['charged_weight']; 
$party_invoice = $lr_row['party_invoice']; 
$lorry_type = $lr_row['lorry_type']; 
$description = $lr_row['nature_of_goods']; 
$policy_no = $lr_row['po_no']; 
// $po_date = $lr_row['po_date']; 
$freight = $lr_row['freight']; 
$truck_no = $lr_row['truck_no']; 
$remark = $lr_row['remark']; 
$gst_paid_by = $lr_row['gst_paid_by'];
$party_amount = $lr_row['party_amount'];
$rate_on = $lr_row['rate_on'];
$eway_bill_no = $lr_row['eway_bill_no'];
$eway_ex_date = $lr_row['eway_ex_date'];
$eway_date = $lr_row['eway_date'];
$nature_of_goods = $lr_row['nature_of_goods'];
$invoice_date = $lr_row['invoice_date'];
$challan_date = $lr_row['po_date'];
$insurance_date = $lr_row['insurance_date'];
$challan_no = $lr_row['challan_no'];
$grand_total = $freight;
$net_amnt = $grand_total;

$fri_grid = "SELECT * FROM lr_grid WHERE master_id = '".$lr_row['id']."' ORDER BY id ASC";
$fri_res_grid = mysqli_query($conn, $fri_grid);

$concatenated_values = "";
$concatenated_pcs = "";
$concatenated_weight = "";
$concatenated_hsn_code = "";
$concatenated_pkgs_type = "";
$concatenated_freight_rate = "";
$concatenated_charged_weight = "";
$concatenated_pcss = "0";
$concatenated_weightt = "0";
$concatenated_charged_weightt = "0";
$concatenated_sr_no = ""; // Add this line to concatenate serial numbers
$sr_no = 1;

while ($fri_row_grid = mysqli_fetch_assoc($fri_res_grid)) {
    $concatenated_values .= $fri_row_grid['description'] . "<br>";
    $concatenated_pcs .= $fri_row_grid['pcs'] . "<br>";
    $concatenated_weight .= $fri_row_grid['weight'] . "<br>";
    $concatenated_hsn_code .= $fri_row_grid['hsn_code'] . "<br>";
    $concatenated_pkgs_type .= $fri_row_grid['pkgs_type'] . "<br>";
    $concatenated_freight_rate .= $fri_row_grid['freight_rate'] . "<br>";
    $concatenated_charged_weight .= $fri_row_grid['charged_weight'] . "<br>";
    $concatenated_sr_no .= $sr_no . "<br><br>"; // Concatenate the serial number
    $sr_no++; // Increment the serial number inside the loop
$concatenated_pcss += $fri_row_grid['pcs'];
$concatenated_weightt += $fri_row_grid['weight'];
$concatenated_charged_weightt += $fri_row_grid['charged_weight'];
}
// Remove the trailing <br> from each concatenated string
$concatenated_values = rtrim($concatenated_values, "<br>");
$concatenated_pcs = rtrim($concatenated_pcs, "<br>");
$concatenated_weight = rtrim($concatenated_weight, "<br>");
$concatenated_charged_weight = rtrim($concatenated_charged_weight, "<br>");
$concatenated_hsn_code = rtrim($concatenated_hsn_code, "<br>");
$concatenated_freight_rate = rtrim($concatenated_freight_rate, "<br>");
$concatenated_pkgs_type = rtrim($concatenated_pkgs_type, "<br>");
$concatenated_sr_no = rtrim($concatenated_sr_no, "<br>"); // Remove trailing <br> from serial numbers

if($invoice_date == '1970-01-01'){
    $invoice_date2 = '';
  }else{
    $invoice_date2 = risFormatDate($invoice_date);
  }

if($challan_date == '1970-01-01'){
    $challan_date2 = '';
  }else{
    $challan_date2 = risFormatDate($challan_date);
  }
  if($insurance_date == '1970-01-01'){
    $insurance_date2 = '';
  }else{
    $insurance_date2 = risFormatDate($insurance_date);
  }

if($eway_ex_date == '1970-01-01'){
    $eway_ex_date2 = '';
}else{
    $eway_ex_date2 = risFormatDate($eway_ex_date);
}


if($eway_date == '1970-01-01'){
    $eway_date2 = '';
}else{
    $eway_date2 = risFormatDate($eway_date);
}

if($lr_date == '1970-01-01'){
    $lr_date2 = '';
}else{
    $lr_date2 = risFormatDate($lr_date);
}


foreach ($array as $key => $freights) {
    $output = ''; 
    if($freights == 'with_freight'){
        $freights = $lr_row['freight'];
        $st_charges = $lr_row['st_charges'];
        $g_total = customFormatMoney($lr_row['st_charges'] + $lr_row['freight']);
    }

    if($freights == 'without_freight'){
        $freights = '';
        $st_charges = '';
        $g_total = '';
    }
   }
$output  = ''; 
$output .= '<!DOCTYPE html>
<html>
<head>
<title>LR COPY</title>
</head>
<body>


<table  style="width:100%;" >
<tr>
    <td style="width:75%;">
        <table cellpadding="1.2" style="width:100%;" >
             <tr>
               <td  style="width:99%;text-align:center;"><img src="../assets/logo/sh_logo.png" alt="logo" style="width:80px; height:35px;"></td>
            </tr>
            <tr>
               <td  style="width:99%;"><img src="../assets/logo/sl_logo.png" alt="logo" style="width:500px; height:60px;"></td>
            </tr>
            <tr>
               <td  style="text-align:center;font-size:9px;font-weight:bold;width:99%;">Plot No.37.38, Office No. 4, Transport Nagar Aslali, Ahmedabad, Gujarat -382427,<br>Mo. :  9898910259,8487810261 Email : sourbhlogistics01@gmail.com </td>
            </tr>
            <tr>
               <td  style="border-top:1px solid black;border-left:1px solid black;border-right:1px solid black;text-align:center;font-size:9px;font-weight:bold;width:50%;"> CAUTION  </td>
               <td  style="border:1px solid black;text-align:center;font-size:12px;font-weight:bold;width:30%;"> '.$lr_copy.' </td>
               <td  style="border:1px solid black;text-align:center;font-size:10px;font-weight:bold;width:21.8%;"> Seal No. </td>
            </tr>
            <tr>
               <td  style="border-bottom:1px solid black;border-left:1px solid black;border-right:1px solid black;text-align:center;font-size:7px;font-weight:bold;width:50%;"> The consignment will not be detained diverted,re-routed or re-booked without consignee written permission will be delivered at the destination.  </td>
               <td  style="border:1px solid black;text-align:center;font-size:9px;font-weight:bold;width:30%;"> AT OWNERS RISK / CARRIER RISK </td>
               <td rowspan="2" style="border:1px solid black;text-align:center;font-size:10px;font-weight:bold;width:21.8%;"> '.$lr_row['seal_no'].'</td>
            </tr>
            <tr>
               <td  style="border-bottom:1px solid black;border-left:1px solid black;font-size:9px;font-weight:bold;width:25%;"> Delivery At  :'.$lr_row['delivery'].' DELIVERY</td>
               <td  style="border-bottom:1px solid black;border-right:1px solid black;font-size:7px;font-weight:bold;width:25%;"> '.$lr_row['notes'].' </td>
               <td  style="border:1px solid black;text-align:center;font-size:10px;font-weight:bold;width:30%;"> INSURANCE</td>
            </tr>
            <tr>
               <td  style="border-left:1px solid black;border-right:1px solid black;height:30px;text-align:center;font-size:10px;font-weight:bold;width:50%;"> PAN NO. : '.$bank_det_rows['panno'].'</td>
               <td rowspan="2" style="border-right:1px solid black;border-bottom:1px solid black;font-size:9px;font-weight:bold;width:51.8%;"> The Customer has stated that :<br> he has not insured the consignment OR he has insured the<br> consignment co Name ________________________________<br> Policy No ___________________ Dt._____________________  </td>
            </tr>
             <tr>
               <td  style="border-bottom:1px solid black;border-left:1px solid black;border-right:1px solid black;text-align:center;font-size:12px;font-weight:bold;width:50%;"> TRANSPORT ID  : '.$bank_det_rows['gst'].'  </td>
            </tr>
        </table>
    </td>
    <td style="width:25%;">
        <table cellpadding="2" style="width:100%;" >
            <tr>
               <td  style="width:99%;border:1px solid black;font-size:10px;font-weight:bold;text-align:center;"> Subject To Ahmedabad Jurisdiction</td>
            </tr>
            <tr>
               <td  style="border-left:1px solid black;border-right:1px solid black;font-size:9px;font-weight:bold;width:99%;">SCHEDULE OF DEMURRAGE </td>
            </tr>
            <tr>
               <td  style="border-bottom:1px solid black;border-right:1px solid black;border-left:1px solid black;font-size:8px;font-weight:bold;width:99%;">Demurrage chargeable after 48 hours from the date of arrival @5/- qty per day  </td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:8.8px;font-weight:bold;width:99%;">NOTICE :  Goods will be delivered against Surrender of Consignee Copy of the goods Receipts and payment of freight terminal tax & other charges if any if delivery not taken within a reasonable time the company shall not be liable for any damage of the goods. the company is not responsible for any leakage if delivery is not taken within 7 days from the date of arrival at destination the destination the demurrage charges as per scheduled will be charge. </td>
            </tr>
            <tr>
               <td  style="width:99%;border:1px solid black;font-size:10px;font-weight:bold;text-align:center;"> LORRY NO</td>
            </tr>
            <tr>
               <td  style="width:99%;border:1px solid black;font-size:12px;font-weight:bold;text-align:center;">  '.$truck_no.'</td>
            </tr>
           
        </table>
    </td>
</tr>

<tr>
    <td style="width:75%;">
        <table cellpadding="2" style="width:100%;" >
            <tr>
               <td  style="border-left:1px solid black;border-top:1px solid black;border-right:1px solid black;font-size:11px;font-weight:bold;width:101.8%;"> Consignor Name & Address : <span style="font-size:10px;">'.$consignor_name.'</span> </td>
            </tr>
           <tr>
               <td  style="border-left:1px solid black;border-right:1px solid black;font-size:10px;font-weight:bold;width:101.8%;"> '.$consignor_address.' </td>
            </tr>
            <tr>
               <td  style="border-left:1px solid black;border-right:1px solid black;font-size:9px;font-weight:bold;width:101.8%;"> GSTIN :  '.$consignor_gstin.' </td>
            </tr>
            <tr>
               <td  style="border-top:1px solid black;border-left:1px solid black;border-right:1px solid black;font-size:11px;font-weight:bold;width:101.8%;"> Consignee Name & Address : <span style="font-size:10px;">'.$consignee_name.'</span> </td>
            </tr>
           <tr>
               <td  style="border-left:1px solid black;border-right:1px solid black;font-size:10px;font-weight:bold;width:101.8%;"> '.$consignee_address.' </td>
            </tr>
            <tr>
               <td  style="border-left:1px solid black;border-right:1px solid black;border-bottom:1px solid black;font-size:9px;font-weight:bold;width:101.8%;"> GSTIN :  '.$consignee_gstin.' </td>
            </tr>
        </table>
    </td>
    <td style="width:25%;">
        <table cellpadding="1.9" style="width:100%;" >
            <tr>
               <td  style="width:99%;border:1px solid black;font-size:10px;font-weight:bold;text-align:center;"> CONSIGNMENT NOTE NO</td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:14px;height:27px;text-align:center;font-weight:bold;width:99%;"> '.substr($bill_no,4).'</td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:12px;text-align:center;font-weight:bold;width:30%;"> Date : </td>
               <td  style="border:1px solid black;font-size:12px;text-align:center;font-weight:bold;width:69%;"> '.$lr_date2.'</td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:12px;text-align:center;font-weight:bold;width:30%;"> From : </td>
               <td  style="border:1px solid black;font-size:12px;text-align:center;font-weight:bold;width:69%;"> '.$from_place.'</td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:12px;text-align:center;font-weight:bold;width:30%;"> To :</td>
               <td  style="border:1px solid black;font-size:12px;text-align:center;font-weight:bold;width:69%;"> '.$to_place.'</td>
            </tr>
        </table>
    </td>
</tr>
<tr>
    <td style="width:75%;">
        <table cellpadding="1" style="width:100%;" >
            <tr>
               <td  style="border-left:1px solid black;border-bottom:1px solid black;font-size:9px;font-weight:bold;width:50%;">CONT. PER.  </td>
               <td  style="border-right:1px solid black;border-bottom:1px solid black;font-size:9px;font-weight:bold;width:51.8%;"> Mob No. : </td>
            </tr>
            <tr>
               <td  style="border:1px solid black;text-align:center;font-size:9px;font-weight:bold;width:20%;">No. Of Pkgs.  </td>
               <td  style="border:1px solid black;text-align:center;font-size:9px;font-weight:bold;width:41.8%;"> Description(Said To Contain) </td>
               <td  style="border:1px solid black;text-align:center;font-size:9px;font-weight:bold;text-align:center;width:10%;">Weight  </td>
               <td  style="border:1px solid black;text-align:center;font-size:9px;font-weight:bold;width:10%;">'.$weight.'  </td>
               <td  style="border:1px solid black;text-align:center;font-size:9px;text-align:center;font-weight:bold;width:20%;"> Rate  </td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;font-weight:bold;width:20%;font-size:10px;" rowspan="2"> '.$concatenated_pcs.' </td>
                <td style="border:1px solid black;text-align:center;font-weight:bold;width:41.8%;font-size:10px;" rowspan="5"> '.$concatenated_values.'</td>
                <td style="border:1px solid black;text-align:center;font-weight:bold;width:20%;font-size:10px;"> Actual Weight </td>
                <td style="border:1px solid black;text-align:center;font-weight:bold;width:20%;font-size:10px;"> Charged    Weight</td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;">'.$concatenated_weight.'</td>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;">'.$concatenated_charged_weight.'</td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;"> Type Of. Pkgs </td>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;"> Size </td>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;"> '.$lr_row['size'].' </td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;" rowspan="2"> '.$packing.' </td>
                <td style="border-right:1px solid black;font-weight:bold;font-size:10px;" colspan="2"> Acknowledgment :  </td>
            </tr>
            <tr>
                <td style="border-right:1px solid black;font-weight:bold;font-size:10px;" colspan="2" rowspan="2">Received the goods in goods order & intact condition. </td>
            </tr>
            <tr>
                <td style="border-right:1px solid black;border-left:1px solid black;text-align:center;font-weight:bold;font-size:10px;"> Invoice No </td>
                <td style="border-right:1px solid black;font-weight:bold;font-size:10px;"> '.$party_invoice.' </td>
            </tr>
            <tr>
                <td style="border-right:1px solid black;border-left:1px solid black;text-align:center;font-weight:bold;font-size:10px;">Date</td>
                <td style="border-right:1px solid black;font-weight:bold;font-size:10px;"> '.$invoice_date2.'</td>
                <td style="border-right:1px solid black;border-bottom:1px solid black;text-align:center;font-weight:bold;font-size:10px;" colspan="2" rowspan="5"></td>
            </tr>
            <tr>
                <td style="border-left:1px solid black;border-right:1px solid black;border-top:1px solid black;text-align:center;font-weight:bold;font-size:10px;">Way Bill /Permit No : </td>
                <td style="border-left:1px solid black;border-top:1px solid black;border-right:1px solid black;font-weight:bold;font-size:10px;"> '.$eway_bill_no.'</td>
            </tr>
             <tr>
                <td style="border-left:1px solid black;border-right:1px solid black;text-align:center;font-weight:bold;font-size:10px;">Way Bill Ex date  : </td>
                <td style="border-left:1px solid black;border-right:1px solid black;font-weight:bold;font-size:10px;"> '.$eway_date2.'</td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;"> Basis Of Booking </td>
                <td style="border:1px solid black;font-weight:bold;font-size:10px;"> '.$lr_row['lr_mode'].'</td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;font-weight:bold;font-size:10px;"> Invoice  Value </td>
                <td style="border:1px solid black;font-weight:bold;font-size:10px;"> GST Tax Paid by '.$gst_paid_by.' </td>
            </tr>
            <tr>
                <td style="border:1px solid black;text-align:center;width:20%;font-weight:bold;font-size:10px;"> '.$partyamount.' </td>
                <td style="border:1px solid black;font-weight:bold;width:81.8%;font-size:10px;"> Note :  '.$remark.' </td>
            </tr>
           
        </table>
    </td>
    <td style="width:25%;">
        <table cellpadding="3" style="width:100%;" >
           <tr>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:50%;">  </td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> Amount Rs</td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> Freight </td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> '.$freights.'</td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> Sur Charge</td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> </td>
            </tr>
             <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> Colle Ch.</td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> </td>
            </tr>
             <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> Door Del Ch</td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> </td>
            </tr>
             <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> Hamali Ch</td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> </td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> St Charge</td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> '.$st_charges.' </td>
            </tr>
            <tr>
               <td  style="border:1px solid black;font-size:10px;font-weight:bold;width:50%;"> Grand Total</td>
               <td  style="border:1px solid black;font-size:10px;text-align:center;font-weight:bold;width:49%;"> '.$g_total.' </td>
            </tr>
            <tr>
               <td  style="border-right:1px solid black;height:46.5px;border-left:1px solid black;font-size:10px;font-weight:bold;width:99%;text-align:center;"><img src="../assets/logo/sh_stamp.png" alt="logo" style="width:55px; height:38px;"></td>
            </tr>
            <tr>
               <td  style="border-right:1px solid black;border-left:1px solid black;border-bottom:1px solid black;font-size:10px;font-weight:bold;width:99%;">Signature of Booking Clerk</td>
            </tr>

        </table>
    </td>
</tr>
</table>
</body>
</html>';
/*echo'<pre>';
print_r($output);
echo'</pre>';
die();*/
$pdf->AddPage('L', 'A4');

$pdf->writeHTML($output, true, false, false, false, '');

}

$pdf->SetPrintFooter(false);

$pdf->SetTitle('LR NO'.'-'.substr($lr_row['lr_no'], 4));

$pdf->Output('lr_no'.'_'.substr($lr_row['lr_no'], 4).'.pdf', 'I');
?>