<?php
include("../config.php");
require_once '../assets/plugins/pdf/tcpdf.php'; 
$pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetAutoPageBreak(TRUE, 10);
$pdf->SetMargins(10, 15, 7);
$pdf->SetFont('helvetica', '', '7', '', true);

if(isset($_GET['start_date']) && !empty($_GET['start_date'])) {
	$start_date = date('Y-m-d', strtotime($_GET['start_date']));
}

if(isset($_GET['end_date']) && !empty($_GET['end_date'])) {
	$end_date = date('Y-m-d', strtotime($_GET['end_date']));
}

$query = mysqli_query($conn, "SELECT * FROM `lr_mst` WHERE l_date >= '".$start_date."' AND l_date <= '".$end_date."' AND company_id = '".$_SESSION['company_id']."' AND branch_id = '".$_SESSION['branch_id']."' ORDER BY l_date");
$data = array();
while ($row = mysqli_fetch_assoc($query)) {
	$data[] = $row;
}

$master_company  = combine(getAllRecords('company_mst'), 'id', 'name');
$master_vendor = combine(getAllRecords('vendor_master'), 'id', 'name');
$table = '';
$table .= '<table cellpadding="2">
<thead>
	<tr>
		<td style="width:100%;font-size:13px;font-weight:bolder">'.@$master_company[$_SESSION['company_id']].'</td>
	</tr>
	<tr>
		<td style="width:100%;font-size:10px;">Pending POD Register From Date : '.risFormatDate($_GET['start_date'],'d/m/Y').' To Date '.risFormatDate($_GET['end_date'],'d/m/Y').'</td>
	</tr>
	<tr>
	  <th style="width:10%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black">LR NO.</th>

	  <th style="width:10%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black">DATE</th>

	  <th style="width:13%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black">TRUCK NO</th>

	  <th style="width:15%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black">CONSIGNOR</th>

	  <th style="width:15%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black">CONSIGNEE</th>

	  <th style="width:15%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black">AGENT</th>

	  <th style="width:12%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black;text-align:center">FROM</th>

	  <th style="width:12%;font-size:8px;border-top:1px solid black;font-weight:bolder;border-bottom:1px solid black;text-align:center">TO</th>
	</tr>
	</thead>
<tbody>';
if(count($data) > 0){
	foreach ($data as $key => $datas) {
		$table .= '
			<tr>
				<td style="width:10%;">'.$datas['lr_no'].'</td>
				<td style="width:10%;">'.risFormatDate($datas["l_date"],'d-m-Y').'</td>
				<td style="width:13%;">'.$datas["truck_no"].'</td>
				<td style="width:15%;">'.@$master_vendor[$datas['consignor_name']].'</td>
				<td style="width:15%;">'.@$master_vendor[$datas['consignee_name']].'</td>
				<td style="width:15%;">'.$datas['agent'].'</td>
				<td style="width:12%;text-align:center">'.$datas["from_place"].'</td>
				<td style="width:12%;text-align:center">'.$datas["to_place"].'</td>
			</tr>
		';
	}
}
$table .='</tbody>
</table>
';

$pdf->AddPage();
$pdf->writeHTML($table, true, false, false, false, '');
$pdf->SetPrintFooter(true);
$pdf->SetTitle('PENDING POD REGISTER');
$pdf->Output('pending_pod_register.pdf', 'I');
?>